DROP TABLE IF EXISTS order_products;
DROP TABLE IF EXISTS orders;
DROP TABLE IF EXISTS customers;
DROP TABLE IF EXISTS products;

CREATE TABLE products (
	product_id SERIAL PRIMARY KEY,
	product_name VARCHAR(100) NOT NULL,
	-- 10 cyfr, z czego 2 po prawej stronie kropki
	-- zakres wartości od -99999999.99 do +99999999.99
	-- inna nazwa: DECIMAL, w Oraclu nazwa NUMBER
	price NUMERIC(10, 2) NOT NULL,
	vat NUMERIC(2, 2), -- wartości do 0.99
	description TEXT -- w Oraclu pod nazwą CLOB
);

-- Nie zawsze kluczem głównym jest automatycznie generowany numer.
-- Kluczem może być też kolumna tekstowa, albo typu "data z czasem" (timestamp).
-- Przykładowo tutaj napiszemy, że kluczem klienta jest jego email.
CREATE TABLE customers (
	customer_email VARCHAR(100) PRIMARY KEY,
	customer_name VARCHAR(100) NOT NULL,
	phone_number VARCHAR(20),
	address VARCHAR(250),
	postal_code VARCHAR(10),
	city VARCHAR(100)
);

CREATE TABLE orders (
	order_id SERIAL PRIMARY KEY,
	customer_email VARCHAR(100) NOT NULL REFERENCES customers(customer_email),
	status VARCHAR(20) NOT NULL,
	order_date TIMESTAMP NOT NULL,
	delivery_date DATE
);

CREATE TABLE order_products (
	order_id INTEGER NOT NULL REFERENCES orders(order_id),
	product_id INTEGER NOT NULL REFERENCES products(product_id),
	quantity SMALLINT NOT NULL,
	actual_price NUMERIC(10, 2) NOT NULL,
	actual_vat NUMERIC(2, 2),
	PRIMARY KEY(order_id, product_id)
);
