package sprzedaz;

import java.math.BigDecimal;
import java.util.List;

import javax.swing.JOptionPane;

public class SumaJednegoMiasta_Funkcyjnie1 {
    // W tej wersji obliczamy sumę jako BigDecimal, funkcyjnie, wykorzystując tylko dostęp do pól rekordu.
    
    public static void main(String[] args) {
        String miasto = JOptionPane.showInputDialog("Podaj miasto:");
        List<Transakcja> transakcje = ObslugaCsvTransakcji.wczytaj();
        
        BigDecimal suma = transakcje.stream()
                .filter(tr -> tr.miasto().equalsIgnoreCase(miasto))
                .map(tr -> tr.cena().multiply(BigDecimal.valueOf(tr.sztuk())))
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        
        JOptionPane.showMessageDialog(null, "Suma: " + suma);
    }

}
