package sprzedaz;

import javax.swing.*;
import java.util.Comparator;
import java.util.List;

public class Opt3 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();
        String miasto = JOptionPane.showInputDialog("Podaj miasto");

        // Operacja map wykonana na obiekcie Optional zwraca w wyniku Optional
        // który jest pusty, jeśli ten pierwszy był pusty, a zawiera wynik funkcji mapującej, jeśli pierwszy zawierał dane.
        // W tym przypadku z Optional<Rekord> powstaje Optional<String>

        // Operacja orElse odczytuje wartość, która jest w Optionalu (w tym przypadku string "Transakcja z dnia....")
        // a zwraca podaną wartość domyślną, jeśli w Optionalu nie było niczego.
        // Tak pisany orElse ma sens wtedy, gdy wartość domyślna jest zawsze taka sama (nie wymaga obliczeń).
        // Gdy uzyskanie tej wartości wymaga obliczeń, zalecane jest stosowanie orElseGet (zob. następna wersja)

        String tekst = lista.stream()
                .filter(r -> r.miasto().equalsIgnoreCase(miasto))
                .max(Comparator.comparing(Transakcja::wartosc))
                .map(r -> "Transakcja z dnia " + r.data() + " o wartości " + r.wartosc()
                                + "\n" + r.sztuk() + " sztuk towaru " + r.towar())
                .orElse("Nie znaleziono rekordów w podanym mieście");

        JOptionPane.showMessageDialog(null, tekst);

    }
}
