package sprzedaz;

import javax.swing.*;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class Opt2 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();
        String miasto = JOptionPane.showInputDialog("Podaj miasto");

        // Tutaj operacja max zwraca Optional i od razu stosujemy operację ifPresent
        // Kod podany w ifPresent wykona się tylko jeśli wynik został znaleziony

//        lista.stream()
//                .filter(r -> r.miasto().equalsIgnoreCase(miasto))
//                .max(Comparator.comparing(Rekord::wartosc))
//                .ifPresent(r -> JOptionPane.showMessageDialog(null,
//                        "Transakcja z dnia " + r.data() + " o wartości " + r.wartosc()
//                                + "\n" + r.sztuk() + " sztuk towaru " + r.towar()));

        lista.stream()
                .filter(r -> r.miasto().equalsIgnoreCase(miasto))
                .max(Comparator.comparing(Transakcja::wartosc))
                .ifPresentOrElse(
                    r -> JOptionPane.showMessageDialog(null,
                        "Transakcja z dnia " + r.data() + " o wartości " + r.wartosc()
                                + "\n" + r.sztuk() + " sztuk towaru " + r.towar())
                    , () -> JOptionPane.showMessageDialog(null, "Nie ma transakcji w mieście " + miasto,
                                "Brak danych", JOptionPane.ERROR_MESSAGE)
                );

    }
}
