package sprzedaz;

import javax.swing.*;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class Opt1 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();
        String miasto = JOptionPane.showInputDialog("Podaj miasto");

        Optional<Transakcja> wynik = lista.stream()
                .filter(r -> r.miasto().equalsIgnoreCase(miasto))
                .max(Comparator.comparing(Transakcja::wartosc));

        System.out.println("Obiekt wynikowy: " + wynik);
        // sposoby obsługi Optionala
        // klasyczny if

        if(wynik.isPresent()) {
            Transakcja r = wynik.get();
            JOptionPane.showMessageDialog(null,
                    "Transakcja z dnia " + r.data() + " o wartości " + r.wartosc()
                    + "\n" + r.sztuk() + " sztuk towaru " + r.towar());
        } else {
            JOptionPane.showMessageDialog(null, "Nie ma transakcji w mieście " + miasto,
                    "Brak danych", JOptionPane.ERROR_MESSAGE);
        }

    }
}
