package sprzedaz;

import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

// Wersja z liczeniem statystyk, czyli coint, sum, avg, min i max jednocześnie
public class Grupowanie9 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();

        Map<String, DoubleSummaryStatistics> sumy = lista.stream()
                .collect(Collectors.groupingBy(Transakcja::miasto,
                        Collectors.summarizingDouble(Transakcja::wartoscDouble)));

        sumy.forEach((miasto, stats) -> System.out.printf("%-10s : %s%n", miasto, stats));
    }
}
