package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie7 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();

        Map<String, BigDecimal> sumy = lista.stream()
                .collect(Collectors.groupingBy(Transakcja::miasto,
                        Collectors.mapping(Transakcja::wartosc,
                                Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));

        sumy.forEach((miasto, suma) -> System.out.printf("%-10s : %12s%n", miasto, suma));
    }
}
