package sprzedaz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie5 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();
        final Map<String, StatystykiDlaMiasta> mapa = new TreeMap<>();

        for (Transakcja transakcja : lista) {
            final String miasto = transakcja.miasto();
            StatystykiDlaMiasta statystyki = mapa.get(miasto);
            if (statystyki == null) {
                statystyki = new StatystykiDlaMiasta(miasto);
                mapa.put(miasto, statystyki);
            }
            statystyki.update(transakcja);
            // nie trzeba robić put, bo modyfikuję ten obiekt, który już jest w słowniku
        }

        for (StatystykiDlaMiasta statystykiZMiasta : mapa.values()) {
            System.out.println(statystykiZMiasta);
        }
    }

// Klasa zgnieżdżona - tylko dla przykładu.
// Równie dobrze mógłbym tę klase zdefiniować w osobnym pliku.

    // Obiekt tej klasy przechowuje statystyki job
    private static class StatystykiDlaMiasta {
        final String miasto;
        int count = 0;
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal min = null;
        BigDecimal max = null;

        StatystykiDlaMiasta(String miasto) {
            this.miasto = miasto;
        }

        void update(Transakcja transakcja) {
            BigDecimal wartosc = transakcja.wartosc();
            count++;
            sum = sum.add(wartosc);
            if (min == null || wartosc.compareTo(min) < 0) {
                min = wartosc;
            }
            if (max == null || wartosc.compareTo(max) > 0) {
                max = wartosc;
            }
        }

        BigDecimal avg() {
            return sum.divide(BigDecimal.valueOf(count), 2, RoundingMode.HALF_EVEN);
        }

        @Override
        public String toString() {
            return "jobTitle=" + miasto + ", count=" + count + ", sum=" + sum + ", min=" + min + ", max="
                    + max + ", avg=" + avg();
        }

    }
}
