package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/* Operacje "funkcyjne" na słownikach dostępne od Java 8:
   compute, computeIfPresent, computeIfAbsent, putIfAbsent, ...
  */
public class Grupowanie3 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();
        Map<String, BigDecimal> slownik = new TreeMap<>();

        for(Transakcja r : lista) {
            slownik.putIfAbsent(r.miasto(), BigDecimal.ZERO);
            slownik.computeIfPresent(r.miasto(), (k, suma) -> suma.add(r.wartosc()));
            // Funkcja na podstawie klucza i starej wartości ma zwrócić nową wartość.
        }

        for (Map.Entry<String, BigDecimal> entry : slownik.entrySet()) {
            System.out.printf("%-10s : %12s%n", entry.getKey(), entry.getValue());
        }
    }
}
