package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/* Operacja dostępna od Java 8: getOrDefault */
public class Grupowanie2 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();
        Map<String, BigDecimal> slownik = new TreeMap<>();

        for(Transakcja r : lista) {
            BigDecimal suma = slownik.getOrDefault(r.miasto(), BigDecimal.ZERO);
            slownik.put(r.miasto(), suma.add(r.wartosc()));
        }

        for (Map.Entry<String, BigDecimal> entry : slownik.entrySet()) {
            System.out.printf("%-10s : %12s%n", entry.getKey(), entry.getValue());
        }
    }
}
