package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/* Dla każdego miasta występującego w pliku z danymi
   oblicz sumę wartości transakcji w tym mieście.
 */

/* W tej wersji najpierw ustalamy zbiór miast bez powtórzeń,
   a następnie dla każdego miasta przeglądamy wszystkie rekordy z listy i filtrujemy.
   Ma to niską wydajność. Złożoność: liczba miast × licza wszystkich rekordów.
 */
public class Grupowanie0 {
    public static void main(String[] args) {
        List<Transakcja> lista = ObslugaCsvTransakcji.wczytaj();
        Set<String> miasta = new TreeSet<>();
        for(Transakcja r : lista) {
            miasta.add(r.miasto());
        }
        System.out.println(miasta);

        for (String miasto : miasta) {
            BigDecimal suma = BigDecimal.ZERO;
            for (Transakcja r : lista) {
                if(r.miasto().equals(miasto)) {
                    suma = suma.add(r.wartosc());
                }
            }
            System.out.printf("%-10s : %12s%n", miasto, suma);
        }
    }
}
