package rozwiazania_zadan.r3.z3_fraction;

final class Utils {
	private Utils() { }
	
	/** Największy wspólny dzielnik. Implementacja wg poprawionego algorytmu Euklidesa (z modulo zamiast odejmowania).
	 * @param a liczba całkowita
	 * @param b liczba całkowita
	 * @return największy wspólny dzielnik <var>a</var> i <var>b</var>
	 */
	static long gcd(long a, long b) {
		if (a == 0 || b == 0) {
			throw new IllegalArgumentException("gcd argument zero");
		}
		while (b != 0) {
			long old_b = b;
			b = a % b;
			a = old_b;
		}
		return a;
	}

	/** Najmniejsza wspólna wielokrotność.
	 * @param a liczba całkowita
	 * @param b liczba całkowita
	 * @return najmniejsza dodatnia wspólna wielokrotność <var>a</var> i <var>b</var>
	 */
	static long lcm(long a, long b) {
		if (a == 0 || b == 0) {
			throw new IllegalArgumentException("lcm argument zero");
		}
		a = Math.abs(a);
		b = Math.abs(b);
		return a / gcd(a, b) * b;
	}

	/** Potęgowanie liczb całkowitych.
	 * @param base podstawa
	 * @param exp wykładnik
	 * @return <var>base</var> do potęgi <var>exp</var>
	 */
	public static long pow(long base, int exp) {
		long result = 1L;
		for (int i = 1; i <= exp; i++) {
			result *= base;
		}
		return result;
	}
	
}
