package rozwiazania_zadan.r3.ogloszenia;

import java.util.Objects;

public class Sprzedawca {
	private String imie, nazwisko;
	private String telefon;
	private String email;
	private AdresPocztowy adres;
	
	public Sprzedawca(String imie, String nazwisko, String telefon, String email, AdresPocztowy adres) {
		this.imie = imie;
		this.nazwisko = nazwisko;
		this.telefon = telefon;
		this.email = email;
		this.adres = adres;
	}

	public String getImie() {
		return imie;
	}

	public void setImie(String imie) {
		this.imie = imie;
	}

	public String getNazwisko() {
		return nazwisko;
	}

	public void setNazwisko(String nazwisko) {
		this.nazwisko = nazwisko;
	}

	public String getTelefon() {
		return telefon;
	}

	public void setTelefon(String telefon) {
		this.telefon = telefon;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public AdresPocztowy getAdres() {
		return adres;
	}

	public void setAdres(AdresPocztowy adres) {
		this.adres = adres;
	}

	@Override
	public String toString() {
		return imie + " " + nazwisko
				+ (telefon != null ? (", tel. " + telefon) : "")
				+ (email != null ? (", email " + email) : "")
				+ (adres != null ? (", adres " + adres) : "");
	}

	@Override
	public int hashCode() {
		return Objects.hash(adres, email, imie, nazwisko, telefon);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Sprzedawca other = (Sprzedawca) obj;
		return Objects.equals(adres, other.adres) && Objects.equals(email, other.email)
				&& Objects.equals(imie, other.imie) && Objects.equals(nazwisko, other.nazwisko)
				&& Objects.equals(telefon, other.telefon);
	}
	
}
