package rozwiazania_zadan.r3.ogloszenia;

import java.util.Objects;

public class OgloszenieSamochodowe extends Ogloszenie {
	private String marka, model;
	private int rocznik;
	private long stanLicznika;
	private RodzajNapedu naped;
	
	public OgloszenieSamochodowe(String tytul, int cena, Sprzedawca sprzedawca, String marka, String model, int rocznik,
			long stanLicznika, RodzajNapedu naped) {
		super(tytul, cena, sprzedawca);
		this.marka = marka;
		this.model = model;
		this.rocznik = rocznik;
		this.stanLicznika = stanLicznika;
		this.naped = naped;
	}

	public String getMarka() {
		return marka;
	}

	public void setMarka(String marka) {
		this.marka = marka;
	}

	public String getModel() {
		return model;
	}

	public void setModel(String model) {
		this.model = model;
	}

	public int getRocznik() {
		return rocznik;
	}

	public void setRocznik(int rocznik) {
		this.rocznik = rocznik;
	}

	public long getStanLicznika() {
		return stanLicznika;
	}

	public void setStanLicznika(long stanLicznika) {
		this.stanLicznika = stanLicznika;
	}
	
	public RodzajNapedu getNaped() {
		return naped;
	}
	
	public void setNaped(RodzajNapedu naped) {
		this.naped = naped;
	}

	@Override
	public String toString() {
		return "OgloszenieSamochodowe: " + super.toString() + ", marka=" + marka + ", model=" + model + ", rocznik=" + rocznik + ", stanLicznika="
				+ stanLicznika + " napęd=" + naped;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + Objects.hash(marka, model, rocznik, stanLicznika, naped);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		OgloszenieSamochodowe other = (OgloszenieSamochodowe) obj;
		return Objects.equals(marka, other.marka) && Objects.equals(model, other.model) && rocznik == other.rocznik
				&& stanLicznika == other.stanLicznika && naped == other.naped;
	}
	
}
