package rozwiazania_zadan.r3.ogloszenia;

import java.util.Objects;

public class OgloszenieMieszkaniowe extends Ogloszenie {
	private String miasto, dzielnica;
	private double metraz;
	private int pietro, liczbaPokoi;
	
	public OgloszenieMieszkaniowe(String tytul, int cena, Sprzedawca sprzedawca, String miasto, String dzielnica,
			double metraz, int pietro, int liczbaPokoi) {
		super(tytul, cena, sprzedawca);
		this.miasto = miasto;
		this.dzielnica = dzielnica;
		this.metraz = metraz;
		this.pietro = pietro;
		this.liczbaPokoi = liczbaPokoi;
	}

	public String getMiasto() {
		return miasto;
	}

	public void setMiasto(String miasto) {
		this.miasto = miasto;
	}

	public String getDzielnica() {
		return dzielnica;
	}

	public void setDzielnica(String dzielnica) {
		this.dzielnica = dzielnica;
	}

	public double getMetraz() {
		return metraz;
	}

	public void setMetraz(double metraz) {
		this.metraz = metraz;
	}

	public int getPietro() {
		return pietro;
	}

	public void setPietro(int pietro) {
		this.pietro = pietro;
	}

	public int getLiczbaPokoi() {
		return liczbaPokoi;
	}

	public void setLiczbaPokoi(int liczbaPokoi) {
		this.liczbaPokoi = liczbaPokoi;
	}

	@Override
	public String toString() {
		return "OgloszenieMieszkaniowe: " + super.toString() + ", miasto= " + miasto + ", dzielnica=" + dzielnica + ", metraz=" + metraz
				+ ", pietro=" + pietro + ", liczbaPokoi=" + liczbaPokoi;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + Objects.hash(dzielnica, liczbaPokoi, metraz, miasto, pietro);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		OgloszenieMieszkaniowe other = (OgloszenieMieszkaniowe) obj;
		return Objects.equals(dzielnica, other.dzielnica) && liczbaPokoi == other.liczbaPokoi
				&& Double.doubleToLongBits(metraz) == Double.doubleToLongBits(other.metraz)
				&& Objects.equals(miasto, other.miasto) && pietro == other.pietro;
	}
	
}
