package rozwiazania_zadan.r3.ogloszenia;

import java.util.Objects;

public class Ogloszenie {
	private String tytul;
	private int cena;
	private Sprzedawca sprzedawca;
	
	public Ogloszenie(String tytul, int cena, Sprzedawca sprzedawca) {
		this.tytul = tytul;
		this.cena = cena;
		this.sprzedawca = sprzedawca;
	}

	public String getTytul() {
		return tytul;
	}

	public void setTytul(String tytul) {
		this.tytul = tytul;
	}

	public int getCena() {
		return cena;
	}

	public void setCena(int cena) {
		this.cena = cena;
	}

	public Sprzedawca getSprzedawca() {
		return sprzedawca;
	}

	public void setSprzedawca(Sprzedawca sprzedawca) {
		this.sprzedawca = sprzedawca;
	}

	@Override
	public String toString() {
		return tytul + ", cena " + cena + " zł, sprzedawca: " + sprzedawca;
	}

	@Override
	public int hashCode() {
		return Objects.hash(cena, sprzedawca, tytul);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Ogloszenie other = (Ogloszenie) obj;
		return cena == other.cena && Objects.equals(sprzedawca, other.sprzedawca) && Objects.equals(tytul, other.tytul);
	}
	
}
