package rozwiazania_zadan.r3.ogloszenia;

import java.util.Objects;

public class AdresPocztowy {
	private String ulica_numer;
	private String kodPocztowy;
	private String miasto;
	
	public AdresPocztowy(String ulica_numer, String kodPocztowy, String miasto) {
		this.ulica_numer = ulica_numer;
		this.kodPocztowy = kodPocztowy;
		this.miasto = miasto;
	}

	public String getUlica_numer() {
		return ulica_numer;
	}

	public void setUlica_numer(String ulica_numer) {
		this.ulica_numer = ulica_numer;
	}

	public String getKodPocztowy() {
		return kodPocztowy;
	}

	public void setKodPocztowy(String kodPocztowy) {
		this.kodPocztowy = kodPocztowy;
	}

	public String getMiasto() {
		return miasto;
	}

	public void setMiasto(String miasto) {
		this.miasto = miasto;
	}

	@Override
	public String toString() {
		return ulica_numer + " " + kodPocztowy + " " + miasto;
	}

	@Override
	public int hashCode() {
		return Objects.hash(kodPocztowy, miasto, ulica_numer);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AdresPocztowy other = (AdresPocztowy) obj;
		return Objects.equals(kodPocztowy, other.kodPocztowy) && Objects.equals(miasto, other.miasto)
				&& Objects.equals(ulica_numer, other.ulica_numer);
	}
	
}
