package rozwiazania_zadan.r2.z3_funkcje_konwersje;
/* Tego nie było w naszych zestawach, ale też warto zobaczyć: klasa z metodami statycznymi, czyli "funkcjami". */

public class KonwersjeJednostek {
	
	static double cale_na_cm(double cale) {
		return cale * 2.54;
	}
	
	static double cm_na_cale(double cm) {
		return cm / 2.54;
	}
	
	static double mile_na_km(double mile) {
		return mile * 1.609344;
	}
	
	public static double km_na_mile(double km) {
		return km / 1.609344;
	}
	
	public static double far_na_celc(double far) {
		// to dawało złe wyniki z poowdu dzielenia całkowitego 5/9 == 0
		// return 5/9 * (far - 32);
		
		// przykładowe dobre rozwiązania
		// return 5.0 / 9.0 * (far - 32.0);
		return 5. / 9. * (far - 32.);
		// return (far - 32) / 1.8;
		
		// Jeśli zacznę od zmiennej typu double to będzie OK (Java liczy od lewej do prawej)
		// return (far - 32) * 5 / 9;
	}
	
	public static double celc_na_far(double cel) {
		//źle return 32 + 9/5 * cel;
		
//		return 32.0 + 9./5. * cel;
//		return 32 + 1.8 * cel;
		return cel * 9 / 5 + 32;
	}
	
	public static void main(String[] args) {
		System.out.println(cale_na_cm(0));
		System.out.println(cale_na_cm(10));
		System.out.println(cale_na_cm(17));
		System.out.println();
		
		System.out.println(mile_na_km(100));
		System.out.println();
		System.out.println(km_na_mile(100));
		System.out.println(km_na_mile(160));
		System.out.println();
		
		System.out.println(far_na_celc(0));  // -17.7
		System.out.println(far_na_celc(100)); // 37.7
		System.out.println();
		System.out.println(celc_na_far(0)); // 32
		System.out.println(celc_na_far(37)); // około 100
		System.out.println(celc_na_far(100)); // 212
		
	}
	

}
