package p36_lokalizacja.formatowanie;

import java.text.NumberFormat;
import java.util.Locale;

public class PredefinedFormats_Number {

	public static void displayNumbers(Locale locale) {
		Integer i = new Integer(123456);
		Double d = new Double(1654.32173645263);

		//NumberFormat nf = NumberFormat.getNumberInstance(locale);
		NumberFormat nf = NumberFormat.getInstance(locale);
		//nf.setMaximumFractionDigits(6);
		System.out.println(nf.format(i));
		System.out.println(nf.format(d));
	}

	public static void displayPercent(Locale locale) {
		Integer i = new Integer(13);
		Double d = new Double(0.7533);

		NumberFormat nf = NumberFormat.getPercentInstance(locale);
		System.out.println(nf.format(i));
		System.out.println(nf.format(d));
	}

	public static void displayCurrencies(Locale locale) {
		Double d = new Double(2200.90);

		NumberFormat nf = NumberFormat.getCurrencyInstance(locale);
		System.out.println(nf.format(d));
	}

	public static void main(String[] args) {
		Locale[] all = {
			new Locale("pl", "PL"),
			new Locale("pl"),
			new Locale("de", "DE"),
			new Locale("fr", "FR"),
			new Locale("en", "GB"),
			new Locale("en", "US"),
			new Locale("en") };

		for (Locale locale : all) {
			System.out.println("Dla locali " + locale.toString());
			displayNumbers(locale);
			displayPercent(locale);
			displayCurrencies(locale);
			System.out.println();
		}
	}

}
