package p36_lokalizacja;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class EnumerateBundle {

	public static void main(String[] args) {
		Locale actualLocale;

		if (args.length == 2) {
			String language = args[0];
			String country = args[1];
			actualLocale = new Locale(language, country);
		} else {
			actualLocale = Locale.getDefault();
		}
		ResourceBundle messages = ResourceBundle.getBundle("pakiet.NaszBundle", actualLocale);

		Enumeration<String> bundleKeys = messages.getKeys();
		while (bundleKeys.hasMoreElements()) {
		    String key = (String)bundleKeys.nextElement();
		    String value = messages.getString(key);
		    System.out.println("key = " + key + ", " + "value = " + value);
		}
	}
}
