package p25_lambdy;

import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class InterfejsyFunkcyjneJavy {

	public static void main(String[] args) {
		DoubleUnaryOperator doKwadratu = x -> x*x;
		System.out.println(doKwadratu.applyAsDouble(3.0));

		DoubleUnaryOperator doKwadratuPlus100 = doKwadratu.andThen(x -> x + 100);
		System.out.println(doKwadratuPlus100.applyAsDouble(6)); // 6*6 + 100

		Function<String, String> f = s -> s.strip().toUpperCase();
		String wynik = f.apply("   Ala nie ma psa    ");
		System.out.println(wynik);
		
		Predicate<String> predykat = s -> s.contains("kot");
		if(predykat.test("Ala ma kota")) {
			System.out.println("kot jest");
		} else {
			System.out.println("kota nie ma");			
		}
		System.out.println();
		
		Consumer<String> akcja = s -> System.out.println(" * " + s);
		
		// Typowym zastosowaniem jest jednak filtrowanie i mapowanie strumieni
		String[] teksty = {
				"   Ala ma kota",
				"Ola ma psa    ",
				"  Ewa ma kotka i rybki"
		};
		
		Stream.of(teksty)
			.filter(predykat)
			.map(f)
			.forEach(akcja);
	}

}
