package p24_pliki;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalTime;

public class Zapis4 {
    /* W tej wersji używamy konstrukcji "try-with-resources" wprowadzonej w Java 7.
     * Plik (lub inny "zasób" - obiekt implementujący interfejs AutoCloseable) otwieramy w nawiasach okrągłych za try()
     * Java automatycznie zamknie ten plik z takimi samymi gwarancjami, jak finally.
     * My jawnie nie piszemy już close
     */
    public static void main(String[] args) {
        LocalTime now = LocalTime.now();
        System.out.println(now);
        int sekunda = now.getSecond() % 10;
        System.out.println("Sekunda: " + sekunda);

        try(PrintWriter out = new PrintWriter("out/zapis4.txt")) {
            out.println("Ala ma kota");
            out.println("Ola ma psa");
            out.println("Odczyt czasu: " + now);
            out.println("Sekunda: " + sekunda);
            out.println("Wynik dzielenia: " + (100 / sekunda));
            out.println("Ela ma chomika");
            out.println("Koniec");

            System.out.println("Gotowe");
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}
