package p24_pliki;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalTime;

public class Zapis3 {
    /* Tradycyjny sposób zamykania plików (i innych zasobów) oparty o klauzulę finally.
     * Jest to poprawne rozwiązanie, stosowane standardowo do Javy 6,
     * a obecnie potrzebne czasami, gdy jakaś klasa nie obsługuje "AutoCloseable".
     *
     * Sekcja finally wykona się w sytuacjach gdy:
     * - program normalnie dojdzie do końca try
     * - wewnątrz try dojdzie do wyjątku, który zostanie obsłużony w jednym z catch
     * - dojdzie do wyjątku, który nie zostanie obsłużony
     * - program wyjdzie z sekcji try z powodu instrukcji takiej jak return, break, continue
     * Sekcja finally nie wykona się, gdy:
     * - zostanie wywołane System.exit()
     * - "ktoś wyłączy prąd" :-)
     */
    public static void main(String[] args) {
        LocalTime now = LocalTime.now();
        System.out.println(now);
        int sekunda = now.getSecond() % 10;
        System.out.println("Sekunda: " + sekunda);

        PrintWriter out = null;
        try {
            out = new PrintWriter("out/zapis3.txt");
            out.println("Ala ma kota");
            out.println("Ola ma psa");
            out.println("Odczyt czasu: " + now);
            out.println("Sekunda: " + sekunda);
            out.println("Wynik dzielenia: " + (100 / sekunda));
            out.println("Ela ma chomika");
            out.println("Koniec");

            System.out.println("Gotowe");
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        } finally {
            if(out != null)
                out.close();
        }
    }
}
