package p24_pliki;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PosortujTadeusza3 {
    static int nr = 0;
    // Z wyrażeń lambda nie wolno modyfikować zmiennych lokalnych zadeklarowanych w metodzie otaczającej.
    // Tutaj używam zmiennej statycznej, aby ponumerować linie.
    // Uwaga, takie podejście ze zmienną jest poprawne tylko w przypadku strumienia sekwencyjnego,
    // a byłoby błędem w przypadku wielowątkowego (parallelStream).

    // W tej wersji wynikowe linie najpierw zbieramy do listy, a następnie zapisujemy.

    public static void main(String[] args) {
        System.out.println("Startujemy");
        List<String> lista = List.of();

        try(Stream<String> lines = Files.lines(Paths.get("pliki/pan_tadeusz.txt"))) {
            lista = lines
                    .map(String::strip)
                    .filter(s -> !s.isEmpty())
                    // .sorted()
                    .sorted(Collator.getInstance())
                    .map(s -> String.format("%6d: %s", ++nr, s))
                    .collect(Collectors.toList());
        } catch (IOException e) {
            e.printStackTrace();
        }

        try {
            System.out.println("Zapisuję");
            Files.write(Paths.get("out/posorotwane.txt"), lista);
        } catch (IOException e) {
            e.printStackTrace();
        }

        System.out.println("Gotowe");
    }
}
