package p24_pliki;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;

public class PosortujTadeusza2 {
    static int nr = 0;
    // Z wyrażeń lambda nie wolno modyfikować zmiennych lokalnych zadeklarowanych w metodzie otaczającej.
    // Tutaj używam zmiennej statycznej, aby ponumerować linie.
    // Uwaga, takie podejście ze zmienną jest poprawne tylko w przypadku strumienia sekwencyjnego,
    // a byłoby błędem w przypadku wielowątkowego (parallelStream).

    // W tej wersji otwieramy obiekt PrintWriter i od razu w locie zapisujemy linie.

    public static void main(String[] args) {
        System.out.println("Startujemy");
        try(Stream<String> lines = Files.lines(Paths.get("pliki/pan_tadeusz.txt"));
            PrintWriter out = new PrintWriter("out/posortowane.txt")) {

            lines
                    .map(String::strip)
                    .filter(s -> !s.isEmpty())
                    // .sorted()
                    .sorted(Collator.getInstance())
                    .map(s -> String.format("%6d: %s", ++nr, s))
                    .forEach(out::println);

        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Gotowe");
    }
}
