package p24_pliki;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.List;
import java.util.Locale;

/* Do pliku out/posortowane.txt
   zapisz treść Pana Tadeusza zmienioną w taki sposób:
   - pominięte puste linie
   - można też usunąć wcięcia
   - linie posortowane alfabetycznie
   - ponumerowane (na początku każdej linii ma być kolejny numer)
 */
public class PosortujTadeusza1 {
    public static void main(String[] args) {

        try {
            System.out.println("Czytam");
            List<String> lines = Files.readAllLines(Paths.get("pliki/pan_tadeusz.txt"));
            System.out.println("Filtruję");
            // podmiana wszystkich elementów listy na wyniki podanej funkcji
            // tutaj: usunięcie białych znaków z początku i końca Stringa
            lines.replaceAll(String::strip);

            // usunięcie pustych linii (removeIf usuwa te elementy listy, dla których podana operacja zwraca true)
            lines.removeIf(String::isEmpty);

            System.out.println("Sortuję");

            // Wg kodów Unicode
            // lines.sort(null);

            // Wg własnego pomysłu, np. wg długości tekstów
            // lines.sort((s1, s2) -> s1.length() - s2.length());

            // Zgodnie z alfabetem bieżącego języka systemowego
            // lines.sort(Collator.getInstance());

            // Zgodnie z alfabetem konkrentego języka
            // lines.sort(Collator.getInstance(Locale.FRENCH));
            // lines.sort(Collator.getInstance(new Locale("en", "GB")));
            lines.sort(Collator.getInstance(new Locale("pl", "PL")));

            System.out.println("Numerowanie");
            // Tutaj zapis ze zwykłą pętlą. Dałoby się też replaceAll, ale z podobnymi problemami, jak w wersji strumieniowej (PosortujTadeusza2)
            for(int i = 0; i < lines.size(); i++) {
                lines.set(i, String.format("%6d: %s", i, lines.get(i)));
            }

            System.out.println("Zapisuję");
            Files.write(Paths.get("out/posorotwane.txt"), lines);
            System.out.println("Gotowe");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
