package p24_pliki;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;

public class Odczyt5_LinesStream {

	/* Files.lines daje dostęp do linii pliku jako do strumienia Stringów.
	   Samo lines nie wczytuje na raz wszystkich linii do pamięci;
	   operacje map, filter, forEach będą wykonywane dla pojedynczych elementów.
	 */
	public static void main(String[] args) {
		try(Stream<String> lines = Files.lines(Paths.get("pliki/pan_tadeusz.txt"))) {
			lines
					.map(String::strip)
					.filter(linia -> !linia.isEmpty())
					.map(String::toUpperCase)
					.forEach(System.out::println);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
