package p21_tablice;

import java.util.Arrays;

public class A_Wprowadzenie {

	public static void main(String[] args) {
		// Gdy potrzebujemy zapamiętać wiele wartości tego samego typu to niby możemy utworzyć wiele zmiennych:
		String miasto1, miasto2, miasto3;
		miasto1 = "Warszawa";
		miasto2 = "Kraków";
		miasto3 = "Poznań";
		
		System.out.println("Miasto nr 1: " + miasto1);
		System.out.println("Miasto nr 2: " + miasto2);
		System.out.println("Miasto nr 3: " + miasto3);
		System.out.println();
		
		// Takie podejście ma jednak co najmniej 2 wady:
		// 1) nie skaluje się - to jest dobre dla kilku wartości, ale nie tysięcy lub więcej
		// 2) do każdej zmiennej trzeba odwoływać się niezależnie i nie ma jak napisać operacji "dla wszystkich elementów na raz"

		// W takich sytuacjach używa się tablic lub kolekcji.
		// Tablice są rozwiązaniem bardziej podstawowym, są elementem języka;
		// kolekcje (np. listy) to są klasy, których się używa pisząc odp. operacje

		// Deklarujemy zmienną typu "tablica Stringów" i wpisujemy do niej tablicę rozmiaru 10.
		String[] miasta = new String[10];
		
		// Do pojedynczych elementów tablicy można odwoływać się za pomocą tablica[numer] i korzystać podobnie jak ze zwykłych zmiennych:
		miasta[1] = "Warszawa";
		miasta[2] = "Kraków";
		miasta[3] = "Poznań";
		
		System.out.println("Drugim miastem jest " + miasta[2]);
		
		// Numer pozycji można przekazać w zmiennej:
		int pozycja = 3;
		System.out.println("Miasto nr " + pozycja + " to " + miasta[pozycja]);
		System.out.println();
		
		// Ale dla tablic możliwe jest też wykonywanie operacji "dla wszystkich elementów"
		// albo za pomocą pętli, albo dedykowanych metod.
		
		// Jak wypisać cała tablicę?
		// Próba użycia zwykłego print:
		System.out.println(miasta);
		
		// Ale można użyć operacji Arrays.toString
		System.out.println(Arrays.toString(miasta));
		System.out.println();
		
		// Przy okazji widzimy, że:
		// * pozycje w tablicy są numerowane od 0 do rozmiar-1
		// * w miejscach, gdzie nie wpisaliśmy żadnej wartości, mamy null
		
		// Próba dostępu do elementu poza zakresem (czyli tu poza zakresem od 0 do 9) kończy się wyjątkiem:
		//EXN System.out.println(miasta[20]);
		//EXN miasta[10] = "Żyrardów";
	}

}
