package p20_zbieranie_danych;

import java.util.*;

// Zbiory:
// - nie zawierają duplikatów (dodanie kolejny raz tej samej wartości nie zmienia już zbioru),
// - mają prawo zmienić kolejność elementów
//   → HashSet zmienia kolejność
//   → LinkedHashSet nie zmienia kolejności (zachowuje początkową kolejność, w jakiej elementy były dodawane)
//   → TreeSet samoczynnie sortuje elementy
// Podstawową (i wydajną) operacją dla zbioru jest sprawdzenie czy element należy do zbioru.

public class ZbieranieDanych5_Set {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        Set<String> zbior = new HashSet<>();
        System.out.println("Aby zakończyć pobieranie danych, wpisz pusty napis");
        while(true) {
            System.out.print("Podaj kolejną wartość: ");
            String s = scanner.nextLine();
            if(s.isEmpty()) break;
            zbior.add(s);
        }
        System.out.println(zbior);
        System.out.println();

        System.out.println("Podawaj wartości, aby sprawdzić czy należą do zbioru. Zakończ pustym stringiem");
        while(true) {
            System.out.print("Podaj: ");
            String s = scanner.nextLine();
            if(s.isEmpty()) break;
            if(zbior.contains(s)) {
                System.out.println(s + " należy do zbioru");
            } else {
                System.out.println(s + " nie należy do zbioru");
            }
        }
    }
}
