package p12_klasy_technicznie.bilet_v2;

public class KasaBiletowa {

    public int cenaBiletu(Osoba klient) {
        if(klient.ulga()) {
            return 50;
        } else {
            return 100;
        }
    }


    public static void main(String[] args) {
        Osoba o = new Osoba();
        Student s = new Student();
        KasaBiletowa k = new KasaBiletowa();

        // Gdy zmienne są różnych typów, to wszystko OK
        System.out.println("Bilet dla " + o + " kosztuje " + k.cenaBiletu(o));
        System.out.println("Bilet dla " + s + " kosztuje " + k.cenaBiletu(s));
        System.out.println();

        // Jeśli jednak obiekt Student trafi do zmiennej typu Osoba,
        // to podczas wywołania dobrana zostanie metoda z parametrem Osoba,
        // Overloading działa w czasie kompilacji i pod uwagę są brane zadeklarowane typy zmiennych,
        // a nie faktyczna klasa obiektu w pamięci.
        Osoba[] kolejka = {o, s};
        for(Osoba klient : kolejka) {
            System.out.println("Bilet dla " + klient + " kosztuje " + k.cenaBiletu(klient));
        }

    }

}
