package p11_enkapsulacja;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Student extends Osoba {
	private String kierunek;
	private int rok;
	
	// Ukrywamy szczegóły implementacji - klient nie musi wiedzieć, w jaki sposób przechowujemy oceny studenta ("to nasza prywatna sprawa")
	// Żadna inna klasa nie może odwoływać się bezpośrednio do tej tablicy.
	// Dzięki temu mogę swobodnie zmienić tablicę na listę z zachowaniem działania metod publicznych - nikomu to nie powinno przeszkadzać.
	private List<Integer> oceny = new ArrayList<>();

	
	public Student(String imie, String nazwisko, int wiek, String kierunek, int rok) {
		super(imie, nazwisko, wiek);
		this.kierunek = kierunek;
		this.rok = rok;
	}
	
	public String getKierunek() {
		return kierunek;
	}

	public void setKierunek(String kierunek) {
		this.kierunek = kierunek;
	}

	public int getRok() {
		return rok;
	}

	public void setRok(int rok) {
		this.rok = rok;
	}

	public void dodajOcene(int ocena) {
		oceny.add(ocena);
	}

	public double sredniaOcen() {
		double suma = 0.0;
		for (int ocena : oceny) {
			suma += ocena;
		}
		return suma / oceny.size();
	}
	
}
