package p11_enkapsulacja;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;

public class Osoba {
    private String imie, nazwisko;
    private LocalDate dataUrodzenia;

    public Osoba(String imie, String nazwisko, LocalDate dataUrodzenia) {
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.dataUrodzenia = dataUrodzenia;
    }

    public Osoba(String imie, String nazwisko, String dataUrodzenia) {
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.dataUrodzenia = LocalDate.parse(dataUrodzenia);
    }

    public Osoba(String imie, String nazwisko, int wiek) {
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.dataUrodzenia = LocalDate.now().minus(wiek, ChronoUnit.YEARS);
    }

    public String toString() {
        return imie + " " + nazwisko + " (ur. " + dataUrodzenia + ")";
    }

    public String getImie() {
        return imie;
    }

    public String getNazwisko() {
        return nazwisko;
    }

    public LocalDate getDataUrodzenia() {
        return dataUrodzenia;
    }

    public int getWiek() {
        Period czasZycia = Period.between(dataUrodzenia, LocalDate.now());
        return czasZycia.getYears();
        // ile pełnych lat jest w tym okresie czasu?
    }
}
