package p11_enkapsulacja;

public class Konto {
    private final int numer;
    private int saldo;
    private Osoba wlasciciel;

    public Konto(int numer, int saldo, Osoba wlasciciel) {
        if(saldo < 0) {
            throw new IllegalArgumentException("Ujemne saldo!");
        }
        this.numer = numer;
        this.saldo = saldo;
        this.wlasciciel = wlasciciel;
    }

    public int getNumer() {
        return numer;
    }

    public int getSaldo() {
        return saldo;
    }

    public Osoba getWlasciciel() {
        return wlasciciel;
    }

    public void setWlasciciel(Osoba wlasciciel) {
        this.wlasciciel = wlasciciel;
    }

    // Z dwóch różnych powodów nie tworzymy setterów dla pól
    // - numer - ponieważ numer się nie zmienia (takie pole powinno być oznaczone final)
    // - saldo - bo nie chce by ktoś ustawił wartość saldo "bez żadnego trybu",
    //           do zmiany salda bedą służyć dedykowane "metody biznesowe"
    public void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Niedodatnia kwota wpłaty");
        }
        saldo += kwota;
        // prawdę mówiąc, może jeszcze dojść do integer overflow; to ewentualnie można sprawdzać za pomocą Math.addExact
    }

    public void wyplata(int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Niedodatnia kwota wypłaty");
        }
        if(kwota > saldo) {
            throw new BrakSrodkow("Mało kasy na koncie nr " + numer);
        }
        saldo -= kwota;
    }

    public void przelew(int kwota, Konto docelowe) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Niedodatnia kwota przelewu");
        }
        if(kwota > this.saldo) {
            throw new BrakSrodkow("Mało kasy na koncie nr " + numer);
        }
        this.saldo -= kwota;
        docelowe.saldo += kwota;
        // operacja na polu innego obiektu - dopuszczalna
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", saldo=" + saldo + ", wł=" + wlasciciel;
    }
}
