package p10_klasy.v4;

public class Dziedziczenie3 {
    public static void main(String[] args) {
        // Dzięki temu, że "Student jest Osobą" i "Pracownik jest Osobą",
        // można obiekty tych klas umieści w tablicy (kolekcji itp.) osób.
        Osoba[] osoby = {
                new Osoba("Ala", "Kowalska", 44),
                new Osoba("Ola", "Malinowska", 13),
                new Student("Adam", "Abacki", 20, "medycyna", 1),
                new StudentInformatyki("Karol", "Infobacki", 23, 3),
                new Pracownik("Jan", "Kowalski", 40, "kierowca", 3300),
        };

        // Wtedy gdy przeglądamy zawartość w pętli element kolekcji widzimy jako obiekt nadklasy (Osoba)
        for(Osoba o : osoby) {
            System.out.println("\nKolejna osoba to " + o.imie);
            // System.out.println(o.kierunek);
            o.przedstawSie();
            System.out.println("    to jest obiekt klasy: " + o.getClass().getSimpleName());

            // Można jawnie sprawdzić czy zmienna wskazuje na obiekt określonej klasy
            // (lub dalszej podklasy - np. StudentInformatyki byłby w tym sensie Studentem)
            if(o instanceof Student) {
                // Jeśli tak jest, to możemy bezpiecznie zrzutować (cast) zmienną na typ Student
                Student student = (Student) o;

                System.out.println("    To jest student kierunku " + student.kierunek
                        + ", który ma średnią ocen " + student.sredniaOcen());
            }

            // natomiast taki if nie byłby prawdziwy dla obiektu klasy StudentInformatyki
            if(o.getClass() == Student.class) {
                System.out.println("    to jest konkretnie klasy Student");
            }
        }
    }
}
