package p10_klasy.v4;

public class Dziedziczenie1 {
    public static void main(String[] args) {
        // Osoba to jest nadklasa (superclass)
        // Student to jest podklasa (subclass)
        // Klasa Student dziedziczy z klasy Osoba / rozszerza klasę Osoba
        // Klasa Student jest specjalizacją klasy Osoba
        // a klasa Osoba jest generalizacją klasy Student

        Osoba osoba = new Osoba();
        System.out.println("Osoba: " + osoba);

        Student student = new Student();
        System.out.println("Student: " + student);
        System.out.println();

        // Obiekt klasy Osoba posiada tylko te pola i metody, które są zdefiniowane w klasie Osoba (lub Object ;) )
        osoba.imie = "Ala";
        osoba.nazwisko = "Kowalska";
        osoba.wiek = 40;
        System.out.println(osoba.jestPelnoletnia());
        osoba.przedstawSie();
        // Ale w obiekcie Osoba nie ma pól ani metod z klasy Student
        // osoba.kierunek = "medycyna";
        // osoba.dodajOcene(4);
        System.out.println();

        // Obiekt klasy Student posiada wszystkie pola i metody zdefiniowane w klasie Osoba
        student.imie = "Jan";
        student.nazwisko = "Kowalski";
        student.wiek = 20;
        System.out.println(student.jestPelnoletnia());
        // ale dodatkowo posiada pola i metody zdefiniowane w klasie Student.
        student.kierunek = "geologia";
        student.rok = 1;
        student.dodajOcene(4);
        student.dodajOcene(4);
        student.dodajOcene(5);
        System.out.println(student.sredniaOcen());
        student.przedstawSie();
        System.out.println();

        // Student nie tylko posiada wszystkie pola i metody odziedziczone z Osoby,
        // ale także "JEST" Osobą.
        // Zasada podstawiania: wszędzie tam, gdzie oczekiwana jest wartość typu Osoba,
        // można użyć obiektu klasy Student.
        Sklep monopolowy = new Sklep("Procent", 3);
        monopolowy.sprzedajPiwo(osoba, 10);

        // Student może kupić piwo
        monopolowy.sprzedajPiwo(student, 3);

        // Student może być właścicielem konta
        Konto konto = new Konto(1, 3000, student);
        System.out.println(konto);
        System.out.println();

        // Z nadklasy NIE SĄ dziedziczone konstruktory.
        // Fakt, że w klasie Osoba istniał konstruktor (String, String, int)
        // nie powoduje powstania analogicznego konstruktora w klasie Student.
        // Student student2 = new Student("Adam", "Adamowski", 22);

        Student student3 = new Student("Adam", "Adamowski", 22, "budownictwo", 3);
        System.out.println(student3);
        student3.przedstawSie();
    }
}
