package p08_importowanie.wersja_okienkowa;

import static javax.swing.JOptionPane.*;
import static p07_funkcje.FunkcjeGeometryczne.*;

import java.util.Random;

/* import static pakiet.Klasa.* importuje wszystkie rzeczy statyczne z podanej klasy.
 * 
 * Nie da się użyć gwiazdek na poziomie pakietu i klasy w jednym imporcie.
 * To nie pzejdzie:
 * import static p07_funkcje.geometria.*.*;
 */
public class Importowanie5_ImportStaticZGwiazdka {

	public static void main(String[] args) {
		// Tylko, aby pokazać w kontekście importowania, tworzę obiekt Random
		Random random = new Random();
		
		String[] figury = {"kwadrat", "prostokąt", "koło"};
		int poczatkowyWybor = random.nextInt(figury.length);
		
		String figura = (String)showInputDialog(
				null,
				"Wybierz rodzaj figury",
				"Wybór",
				QUESTION_MESSAGE,
				null,
				figury,
				figury[poczatkowyWybor]);

		if(figura == null) {
			return;
		}
		switch(figura) {
			case "kwadrat" -> {
				double a = Double.parseDouble(showInputDialog("Podaj długość boku:"));
				double pole = poleKwadratu(a);
				double obwod = obwodKwadratu(a);
				showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			
			case "prostokąt" -> {
				double a = Double.parseDouble(showInputDialog("Podaj długość 1. boku:"));
				double b = Double.parseDouble(showInputDialog("Podaj długość 2. boku:"));
				double pole = poleProstokata(a, b);
				double obwod = obwodProstokata(a, b);
				showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			case "koło" -> {
				double r = Double.parseDouble(showInputDialog("Podaj promień koła:"));
				double pole = poleKola(r);
				double obwod = obwodKola(r);
				showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
		}
	}

}
