package p08_importowanie.wersja_okienkowa;

import static javax.swing.JOptionPane.QUESTION_MESSAGE;
import static javax.swing.JOptionPane.showInputDialog;
import static javax.swing.JOptionPane.showMessageDialog;

import static p07_funkcje.FunkcjeGeometryczne.obwodKola;
import static p07_funkcje.FunkcjeGeometryczne.obwodKwadratu;
import static p07_funkcje.FunkcjeGeometryczne.obwodProstokata;
import static p07_funkcje.FunkcjeGeometryczne.poleKola;
import static p07_funkcje.FunkcjeGeometryczne.poleKwadratu;
import static p07_funkcje.FunkcjeGeometryczne.poleProstokata;

import java.util.Random;

/* Gdy w programie korzystamy tylko z elementów statycznych klasy X (z metod statycznych, zmiennych statycznych, stałych),
 * to zamiast importować tę klasę i wywoływać te elementy pisząc X.metoda
 * można zaimportować statycznie tę metodę (albo zmienną, stałą ...).
 * 
 * Wtedy w treści programy używamy zaimportowanych rzeczy tak, jakby byly zdefiniowane w naszej klasie.
 * (albo tak jakby były funkcjami, tak jak w Pythonie, C++, PHP itp...)
 * 
 * Nie ma jak użyć import static w stosunku do klasy Random, bo jej używamy w sposób "obiektowy":
 * tworzony jest obiekt klasy Random i na nim wywoływana jest metoda (nie jest statyczna).
 * 
 */
public class Importowanie4_ImportStatic {

	public static void main(String[] args) {
		// Tylko, aby pokazać w kontekście importowania, tworzę obiekt Random
		Random random = new Random();
		
		String[] figury = {"kwadrat", "prostokąt", "koło"};
		int poczatkowyWybor = random.nextInt(figury.length);
		
		String figura = (String)showInputDialog(
				null,
				"Wybierz rodzaj figury",
				"Wybór",
				QUESTION_MESSAGE,
				null,
				figury,
				figury[poczatkowyWybor]);

		if(figura == null) {
			return;
		}
		switch(figura) {
			case "kwadrat" -> {
				double a = Double.parseDouble(showInputDialog("Podaj długość boku:"));
				double pole = poleKwadratu(a);
				double obwod = obwodKwadratu(a);
				showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			
			case "prostokąt" -> {
				double a = Double.parseDouble(showInputDialog("Podaj długość 1. boku:"));
				double b = Double.parseDouble(showInputDialog("Podaj długość 2. boku:"));
				double pole = poleProstokata(a, b);
				double obwod = obwodProstokata(a, b);
				showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			case "koło" -> {
				double r = Double.parseDouble(showInputDialog("Podaj promień koła:"));
				double pole = poleKola(r);
				double obwod = obwodKola(r);
				showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
		}
	}

}
