package p08_importowanie.wersja_okienkowa;

// tego nie trzeba pisać, ale zachowanie jest takie, jakby każdy program miał to na początku
// import java.lang.*;
import java.util.*;
import javax.swing.*;
import p07_funkcje.*;

/* Gdy na końcu polecenia import za nazwą pakietu umieścimy *,
 * to importowane są wszystkie klasy z tego pakietu.
 * To nie importuje podpakietów (podklatalogów).
 * importy z * mają niższy priorytet niż importy bezpośrednie.
 * 
 * Gdy w programie pojawia się jakaś nazwa, to kompilator szuka klasy w takiej kolejności:
 * 1. rzeczy zaimportowane bezpośrednio
 * 2. bieżący pakiet
 * 3. klasy zaimportowane za pomocą * (w tym java.lang)
 * 
 * Czy importowanie wszystkich klas z dużego pakietu sprawia problemy?
 * To nie jest problem z punktu widzenia wydajności, bo import nie ładuje tych klas do pamięci.
 * Natomiast zwiększa to ryzyko kolizji nazw.
 * Znany przykład: java.awt.List (lista wyboru w starej technologii okienkowej) i java.util.List (kolekcja).
 * Sam import nie jest problemem, problem dopiero, gdy użyjemy tej klasy (błąd kompilacji). 
 */
public class Importowanie3_ImportZGwiazdka {

	public static void main(String[] args) {
		// Tylko, aby pokazać w kontekście importowania, tworzę obiekt Random
		Random random = new Random();
		
		String[] figury = {"kwadrat", "prostokąt", "koło"};
		int poczatkowyWybor = random.nextInt(figury.length);
		
		String figura = (String)JOptionPane.showInputDialog(
				null,
				"Wybierz rodzaj figury",
				"Wybór",
				JOptionPane.QUESTION_MESSAGE,
				null,
				figury,
				figury[poczatkowyWybor]);

		if(figura == null) {
			return;
		}
		switch(figura) {
			case "kwadrat" -> {
				double a = Double.parseDouble(JOptionPane.showInputDialog("Podaj długość boku:"));
				double pole = FunkcjeGeometryczne.poleKwadratu(a);
				double obwod = FunkcjeGeometryczne.obwodKwadratu(a);
				JOptionPane.showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			
			case "prostokąt" -> {
				double a = Double.parseDouble(JOptionPane.showInputDialog("Podaj długość 1. boku:"));
				double b = Double.parseDouble(JOptionPane.showInputDialog("Podaj długość 2. boku:"));
				double pole = FunkcjeGeometryczne.poleProstokata(a, b);
				double obwod = FunkcjeGeometryczne.obwodProstokata(a, b);
				JOptionPane.showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			case "koło" -> {
				double r = Double.parseDouble(JOptionPane.showInputDialog("Podaj promień koła:"));
				double pole = FunkcjeGeometryczne.poleKola(r);
				double obwod = FunkcjeGeometryczne.obwodKola(r);
				JOptionPane.showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
		}
	}

}
