package p08_importowanie.wersja_okienkowa;

import java.util.Random;
import javax.swing.JOptionPane;
import p07_funkcje.FunkcjeGeometryczne;

/* W tej wersji stosujemy najbardziej standardowy sposób importowania, najczęściej używany:
   każda klasa, do której odwołuje się nasz program, jest zaimportowana osobnym poleceniem.
 */
public class Importowanie2_PojedynczeImporty {

	public static void main(String[] args) {
		// Tylko, aby pokazać w kontekście importowania, tworzę obiekt Random
		Random random = new Random();
		
		String[] figury = {"kwadrat", "prostokąt", "koło"};
		int poczatkowyWybor = random.nextInt(figury.length);
		
		String figura = (String)JOptionPane.showInputDialog(
				null,
				"Wybierz rodzaj figury",
				"Wybór",
				JOptionPane.QUESTION_MESSAGE,
				null,
				figury,
				figury[poczatkowyWybor]);

		if(figura == null) {
			return;
		}
		switch(figura) {
			case "kwadrat" -> {
				double a = Double.parseDouble(JOptionPane.showInputDialog("Podaj długość boku:"));
				double pole = FunkcjeGeometryczne.poleKwadratu(a);
				double obwod = FunkcjeGeometryczne.obwodKwadratu(a);
				JOptionPane.showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			
			case "prostokąt" -> {
				double a = Double.parseDouble(JOptionPane.showInputDialog("Podaj długość 1. boku:"));
				double b = Double.parseDouble(JOptionPane.showInputDialog("Podaj długość 2. boku:"));
				double pole = FunkcjeGeometryczne.poleProstokata(a, b);
				double obwod = FunkcjeGeometryczne.obwodProstokata(a, b);
				JOptionPane.showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
			case "koło" -> {
				double r = Double.parseDouble(JOptionPane.showInputDialog("Podaj promień koła:"));
				double pole = FunkcjeGeometryczne.poleKola(r);
				double obwod = FunkcjeGeometryczne.obwodKola(r);
				JOptionPane.showMessageDialog(null, "Pole: " + pole + "\nObwód: " + obwod);
			}
		}
	}

}
