package p08_importowanie;

import java.util.Scanner;

import static p07_funkcje.FunkcjeGeometryczne.obwodKola;
import static p07_funkcje.FunkcjeGeometryczne.obwodKwadratu;
import static p07_funkcje.FunkcjeGeometryczne.obwodProstokata;
import static p07_funkcje.FunkcjeGeometryczne.poleKola;
import static p07_funkcje.FunkcjeGeometryczne.poleKwadratu;
import static p07_funkcje.FunkcjeGeometryczne.poleProstokata;

import static p07_funkcje.JednostkiMiary.cel_na_far;
import static p07_funkcje.JednostkiMiary.far_na_cel;
import static p07_funkcje.JednostkiMiary.km_na_mile;
import static p07_funkcje.JednostkiMiary.mile_na_km;

// źle, bo nextDouble nie jest static:
// import static java.util.Scanner.nextDouble;

//można też importować zmienne / stałe statyczne:
import static java.lang.Math.PI;

/* Gdy w programie korzystamy tylko z elementów statycznych klasy X (z metod statycznych, zmiennych statycznych, stałych),
* to zamiast importować tę klasę i wywoływać te elementy pisząc X.metoda
* można zaimportować statycznie tę metodę (albo zmienną, stałą ...).
* 
* Wtedy w treści programy używamy zaimportowanych rzeczy tak, jakby były zdefiniowane w naszej klasie.
* (albo tak jakby były funkcjami, tak jak w Pythonie, C++, PHP itp...)
* 
* Nie ma jak użyć import static w stosunku do klasy Scanner, bo jej używamy w sposób "obiektowy":
* tworzony jest obiekt klasy Scanner i na nim wywoływana jest metoda (nie jest statyczna).
*/

public class Importowanie4 {
	public static void main(String[] args) {
		@SuppressWarnings("resource")
		Scanner scanner = new Scanner(System.in);
		
		petla:
		while(true) {
			System.out.println("\nWybierz figurę:");
			System.out.println("  K  - kwadrat");
			System.out.println("  O  - koło");
			System.out.println("  P  - prostokąt");
			System.out.println("  KM - przelicz kilometry na mile");
			System.out.println("  MK - przelicz mile na kilometry");
			System.out.println("  CF - przelicz °C na °F");
			System.out.println("  FC - przelicz °F na °C");
			System.out.println("  Q  - zakończ");
			String wybor = scanner.next().toUpperCase();
			switch(wybor) {
				case "Q" -> {
					// muszę użyć "etykiety", aby powiedzieć Javie, że przerywam pętlę while, a nie samego switcha
					break petla;
				}
				case "K" -> {
					System.out.print("Podaj długość boku kwadratu: ");
					double a = scanner.nextDouble();
					double pole = poleKwadratu(a);
					double obwod = obwodKwadratu(a);
					System.out.printf("Dla kwadratu o boku %.3f pole wynosi %.3f, a obwód %.3f\n", a, pole, obwod);
				}
				case "P" -> {
					System.out.print("Podaj długość pierwszego boku prostokąta: ");
					double a = scanner.nextDouble();
					System.out.print("Podaj długość drugiego boku prostokąta: ");
					double b = scanner.nextDouble();
					double pole = poleProstokata(a, b);
					double obwod = obwodProstokata(a, b);
					System.out.printf("Dla prostokąta o bokach %.3f i %.3f pole wynosi %.3f, a obwód %.3f\n", a, b, pole, obwod);
				}
				case "O" -> {
					System.out.print("Podaj promień koła: ");
					double r = scanner.nextDouble();
					double pole = poleKola(r);
					double obwod = obwodKola(r);
					System.out.printf("Dla koła o promieniu %.3f pole wynosi %.3f, a obwód %.3f\n", r, pole, obwod);
				}
				case "KM" -> {
					System.out.print("Podaj odległość w kilometrach: ");
					double km = scanner.nextDouble();
					double wynik = km_na_mile(km);
					System.out.printf("%.3f km = %.3f mil\n", km, wynik);
				}
				case "MK" -> {
					System.out.print("Podaj odległość w milach: ");
					double mile = scanner.nextDouble();
					double wynik = mile_na_km(mile);
					System.out.printf("%.3f mil = %.3f km\n", mile, wynik);
				}
				case "FC" -> {
					System.out.print("Podaj temperaturę w Fahrenheitach: ");
					double f = scanner.nextDouble();
					double wynik = far_na_cel(f);
					System.out.printf("%.3f °F = %.3f °C\n", f, wynik);
				}
				case "CF" -> {
					System.out.print("Podaj temperaturę w Celsjuszach: ");
					double c = scanner.nextDouble();
					double wynik = cel_na_far(c);
					System.out.printf("%.3f °C = %.3f °F\n", c, wynik);
				}			
				default -> {
					System.out.println("Nieznane polecenie " + wybor);
				}			
			}
		}
		System.out.println("A liczba pi jest równa około " + PI);
	}
}
