package p08_importowanie;

import java.util.Scanner;

import p07_funkcje.FunkcjeGeometryczne;
import p07_funkcje.JednostkiMiary;

/* W tej wersji stosujemy najbardziej standardowy sposób importowania, najczęściej używany:
każda klasa, do której odwołuje się nasz program, jest zaimportowana osobnym poleceniem.
 
import w Javie NIE służy załadowaniu klas do pamięci, nie wykonuje się w czasie działania programu (tak się dzieje w Python i PHP)
To jest tylko wskazanie z jakiego pakietu pochodzi klasa.

import nie wpływa na wydajność!
*/

public class Importowanie2 {
	public static void main(String[] args) {
		@SuppressWarnings("resource")
		Scanner scanner = new Scanner(System.in);
		
		petla:
		while(true) {
			System.out.println("\nWybierz figurę:");
			System.out.println("  K  - kwadrat");
			System.out.println("  O  - koło");
			System.out.println("  P  - prostokąt");
			System.out.println("  KM - przelicz kilometry na mile");
			System.out.println("  MK - przelicz mile na kilometry");
			System.out.println("  CF - przelicz °C na °F");
			System.out.println("  FC - przelicz °F na °C");
			System.out.println("  Q  - zakończ");
			String wybor = scanner.next().toUpperCase();
			switch(wybor) {
				case "Q" -> {
					// muszę użyć "etykiety", aby powiedzieć Javie, że przerywam pętlę while, a nie samego switcha
					break petla;
				}
				case "K" -> {
					System.out.print("Podaj długość boku kwadratu: ");
					double a = scanner.nextDouble();
					double pole = FunkcjeGeometryczne.poleKwadratu(a);
					double obwod = FunkcjeGeometryczne.obwodKwadratu(a);
					System.out.printf("Dla kwadratu o boku %.3f pole wynosi %.3f, a obwód %.3f\n", a, pole, obwod);
				}
				case "P" -> {
					System.out.print("Podaj długość pierwszego boku prostokąta: ");
					double a = scanner.nextDouble();
					System.out.print("Podaj długość drugiego boku prostokąta: ");
					double b = scanner.nextDouble();
					double pole = FunkcjeGeometryczne.poleProstokata(a, b);
					double obwod = FunkcjeGeometryczne.obwodProstokata(a, b);
					System.out.printf("Dla prostokąta o bokach %.3f i %.3f pole wynosi %.3f, a obwód %.3f\n", a, b, pole, obwod);
				}
				case "O" -> {
					System.out.print("Podaj promień koła: ");
					double r = scanner.nextDouble();
					double pole = FunkcjeGeometryczne.poleKola(r);
					double obwod = FunkcjeGeometryczne.obwodKola(r);
					System.out.printf("Dla koła o promieniu %.3f pole wynosi %.3f, a obwód %.3f\n", r, pole, obwod);
				}
				case "KM" -> {
					System.out.print("Podaj odległość w kilometrach: ");
					double km = scanner.nextDouble();
					double wynik = JednostkiMiary.km_na_mile(km);
					System.out.printf("%.3f km = %.3f mil\n", km, wynik);
				}
				case "MK" -> {
					System.out.print("Podaj odległość w milach: ");
					double mile = scanner.nextDouble();
					double wynik = JednostkiMiary.mile_na_km(mile);
					System.out.printf("%.3f mil = %.3f km\n", mile, wynik);
				}
				case "FC" -> {
					System.out.print("Podaj temperaturę w Fahrenheitach: ");
					double f = scanner.nextDouble();
					double wynik = JednostkiMiary.far_na_cel(f);
					System.out.printf("%.3f °F = %.3f °C\n", f, wynik);
				}
				case "CF" -> {
					System.out.print("Podaj temperaturę w Celsjuszach: ");
					double c = scanner.nextDouble();
					double wynik = JednostkiMiary.cel_na_far(c);
					System.out.printf("%.3f °C = %.3f °F\n", c, wynik);
				}			
				default -> {
					System.out.println("Nieznane polecenie " + wybor);
				}			
			}
		}
	}
}
