package p07_funkcje;

// Komentarz pisany w znacznikach /**    */
// pełni rolę dokumentacji, tzw "javadoc".

/**
 * @author patryk
 *
 * To jest przykład klasy, w której nie ma metody main, tylko są zdefiniowane inne metody.
 * "klasa narzędziowa" / "utility class"
 * Tutaj są to funkcje matematyczne dot. geometrii szkolnej.
 */
public class FunkcjeGeometryczne {
	
	// 4 poziomy dostepu (widoczności): private, pakietowy (domyślny, nie pisze się nic), protected, public
	
	/** Funkcja oblicza pole kwadratu.
	 * @param a długość boku
	 * @return pole kwadratu
	 */
	public static double poleKwadratu(double a) {
		return a*a;
	}

	/** Oblicza obwód kwadratu o podanym boku.
	 * @param a długość boku
	 * @return obliczony obwód kwadratu
	 */
	public static double obwodKwadratu(double a) {
		return 4*a;
	}

	/** Oblicza pole prostokąta o podanych bokach.
	 * @param a długość pierwszego boku
	 * @param b długość drugiego boku
	 * @return obliczone pole prostokąta
	 */
	public static double poleProstokata(double a, double b) {
		return a*b;
	}

	public static double obwodProstokata(double a, double b) {
		return 2*a + 2*b;
	}

	public static double poleKola(double r) {
		return Math.PI * r * r;
	}

	public static double obwodKola(double r) {
		return Math.PI * 2 * r;
	}
}
