package p05_switch;

import javax.swing.*;

// W tej wersji korzystamy z możliwości Java 14: "switch expression".
// switch zwraca wynik, który przechwytujemy i (w tym programie) zapisujemy do zmiennej.
// Tutaj widzimy najprostsze podejście: po prawej stronie strzałek są po prostu wartości wynikowe.
// Wersja bardziej rozbudowana: IleDniMaMiesiac5
public class DzienTygodnia5 {
    public static void main(String[] args) {
        int numer = Integer.parseInt(JOptionPane.showInputDialog("Podaj numer dnia tygodnia [1-7]"));
        try {
            String nazwa = switch (numer) {
                case 1 -> "poniedziałek";
                case 2 -> "wtorek";
                case 3 -> "środa";
                case 4 -> "czwartek";
                case 5 -> "piątek";
                case 6 -> "sobota";
                case 7 -> "niedziela";
                default -> throw new IllegalArgumentException("Nieznany numer " + numer);
            };
            JOptionPane.showMessageDialog(null, "To jest " + nazwa);
        } catch (Exception e) {
            JOptionPane.showMessageDialog(null, e, "Błąd", JOptionPane.ERROR_MESSAGE);
        }

        JOptionPane.showMessageDialog(null, "Koniec programu");
    }

}
