package emps;

import java.util.Comparator;
import java.util.List;

public class P6_Sortowanie_v4 {

	// W Java 8 pojawiły się też kreatory komparatorów, które pozwalają porównywać obiekty zwn wybrane kryteria.
	// Do comparing / comparingInt itd
	// przekazuje się funkcję, która na podstawie obiektu zwraca wybraną wartość, wg której obiekty są porównywane.
	// Najczęściej tą funkcją jest getter odczytujący wybrane pole.
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		emps.sort(Comparator.comparingInt(Employee::getSalary).reversed());
		
		for(Employee emp : emps) {
			System.out.printf("|%-12s|%-15s|%-31s|%6d |%-20s|\n",
					emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary(), emp.getCity());
		}
	}

}
