package emps;

import java.util.Comparator;
import java.util.List;

public class P6_Sortowanie_v1 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		// Do metod sortujących można przekazać obiekt zgodny z interfejsem Comparator.
		// Jest wiele sposobó, aby taki komparator uzyskać.
		// W tej wersji tworzę dodatkową klasę KomparatorPracownikow.
		// Przy okazji: niech to będzie klasa zagnieżdżona.
		KomparatorPracownikow porownywarka = new KomparatorPracownikow();
		emps.sort(porownywarka);
		
		for(Employee emp : emps) {
			System.out.printf("|%-12s|%-15s|%-31s|%6d |%-20s|\n",
					emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary(), emp.getCity());
		}
		System.out.println();
		System.out.printf("Do sortowania %d obiektów potrzebnych było %d porównań.\n",
				emps.size(), porownywarka.liczbaPorownan);
	}
	
	private static class KomparatorPracownikow implements Comparator<Employee> {
		int liczbaPorownan = 0;
		
		// Metody porównujące (Comparator.comparte oraz Comparable.compareTo)
		// zwracają wynik typu int, który ma takie znaczenie:
		// wynik < 0 → lewy argument jest mniejszy od prawego
		// wynik > 0 → lewy argument jest większy od prawego
		// wynik = 0 → oba argumenty są równe
		// TO MY JAKO AUTORZY KOMPARATORA OKREŚLAMY CO JEST MNIEJSZE, A CO WIĘKSZE
		public int compare(Employee emp1, Employee emp2) {
			liczbaPorownan++;
			// System.out.println("porównuję " + emp1.getLastName() + " vs " + emp2.getLastName());
			return emp1.getSalary() - emp2.getSalary();
			// to jest sortowanie rosnące wg pensji
		}
	}

}
