package emps;

import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class P4c_SredniaInteraktywnie {

	public static void main(String[] args) {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setFileFilter(new FileNameExtensionFilter("pliki CSV", "csv", "txt"));
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			// jeśli było Cancel lub wystąpił błąd
			return;
		}
		File plik = chooser.getSelectedFile();
		List<Employee> emps = ObslugaCSV.wczytaj(plik);
		
		// zbieram listę stanowisk do wyboru
		Set<String> jobs = new TreeSet<>();
		for(Employee emp : emps) {
			jobs.add(emp.getJobTitle());
		}
		
		Object szukanyJob = JOptionPane.showInputDialog(null, "Wybierz stanowisko",
				"Pytanie", JOptionPane.QUESTION_MESSAGE, null, jobs.toArray(), null);
		
		int suma = 0;
		int ile = 0;
		for(Employee emp : emps) {
			if(Objects.equals(emp.getJobTitle(), szukanyJob)) {
				suma += emp.getSalary();
				ile++;
			}
		}
		if(ile == 0) {
			JOptionPane.showMessageDialog(null, "Nie ma osób na takim stanowisku", "Brak danych", JOptionPane.WARNING_MESSAGE);
		} else {
			double srednia = (double)suma / ile;
			JOptionPane.showMessageDialog(null, "średnia: " + srednia);
		}
	}

}
