package emps;

import java.io.*;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class ObslugaCSV {

    public static List<Employee> wczytaj() {
        return wczytaj("pliki/emps.csv");
    }

    public static List<Employee> wczytaj(String sciezka) {
        return wczytaj(new File(sciezka));
    }

    public static List<Employee> wczytaj(File plik) {
        List<Employee> emps = new ArrayList<>();
        try (BufferedReader reader = new BufferedReader(new FileReader(plik))) {
            reader.readLine(); // tylko po to, aby pominąć pierwszą linię
            String linia;
            while((linia = reader.readLine()) != null) {
                String[] t = linia.split(";", -1);
// psucie danych, aby sprawdzić porównania z nullem
//                if(t[1].charAt(0) == 'A') {
//                    t[3] = null;
//                }
                Employee emp = new Employee(Integer.parseInt(t[0]),
                        t[1], t[2], t[3], Integer.parseInt(t[4]),
                        LocalDate.parse(t[5]), t[6], t[7], t[8], t[9], t[10]);
                emps.add(emp);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return emps;
    }
}
