package emps;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie5 {
	// W wersjach 3-5 używamy nowych operacji słowników, które pojawiły się w Javie 8.
	
	// Tutaj operacja merge
	// slownik.merge(KLUCZ, WARTOŚĆ, FUNKCJA)
	// Jeśli pod KLUCZem jeszcze niczego nie ma, to wpisywana jest WARTOŚĆ
	// Jeśli pod KLUCZem jest już STARA_WARTOŚĆ, to uruchamiana jest FUNKCJA
	// NOWA_WARTOŚĆ := FUNKCJA(STARA_WARTOŚĆ, WARTOŚĆ)
	// np. jeśli funkcją jest operacja dodawania, to będzie tak:
	// NOWA_WARTOŚĆ := STARA_WARTOŚĆ + WARTOŚĆ
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		Map<String, Integer> sumy = new TreeMap<>();
		Map<String, Integer> ilosci = new TreeMap<>();
				
		for(Employee emp : emps) {
			sumy.merge(emp.getJobTitle(), emp.getSalary(), Integer::sum);
			ilosci.merge(emp.getJobTitle(), 1, Integer::sum);
			// Funkcję aktualizującą można podać w formie wyrażenia lambda:
			// sumy.merge(emp.getJobTitle(), emp.getSalary(), (stare, nowe) -> stare+nowe);
			// ale dla dodawania mamy gotową operację Integer.sum(nowe, stare)
			// i zamiast lambdy używamy referencji do metody (::)
		}
		
		for(String job : sumy.keySet()) {
			int ile = ilosci.get(job);
			int suma = sumy.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("%-32s | %2d | %8.2f\n", job, ile, srednia);
		}
	}

}
