package emps;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie4 {
	// W wersjach 3-5 używamy nowych operacji słowników, które pojawiły się w Javie 8.
	// putIfAbsent / computeIfPresent / compute - operacje, które działają w sposób warunkowy,
	// a przekazuje do nich wartość lub funkcję służącą do zmiany wartości
	// Ta wersja jest imo gorsza od 3 i 5...
	
	// Pzy okazji używamy TreeMap - sortuje dane wg kluczy
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		Map<String, Integer> sumy = new TreeMap<>();
		Map<String, Integer> ilosci = new TreeMap<>();
				
		for(Employee emp : emps) {
			sumy.putIfAbsent(emp.getJobTitle(), 0);
			sumy.computeIfPresent(emp.getJobTitle(), (key, staraSuma) -> staraSuma + emp.getSalary());
			ilosci.putIfAbsent(emp.getJobTitle(), 0);
			ilosci.computeIfPresent(emp.getJobTitle(), (k, v) -> v+1);
		}
		
		for(String job : sumy.keySet()) {
			int ile = ilosci.get(job);
			int suma = sumy.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("%-32s | %2d | %8.2f\n", job, ile, srednia);
		}
	}

}
