package emps;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie3 {
	// W wersjach 3-5 używamy nowych operacji słowników, które pojawiły się w Javie 8.
	// getOrDefault - w razie braku danych zwraca podaną wartość domyślną
	
	// Pzy okazji używamy LinkedHashMap - zachowuje oryginalną kolejność
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		Map<String, Integer> sumy = new LinkedHashMap<>();
		Map<String, Integer> ilosci = new LinkedHashMap<>();
				
		for(Employee emp : emps) {
			int suma = sumy.getOrDefault(emp.getJobTitle(), 0);
			sumy.put(emp.getJobTitle(), suma + emp.getSalary());
			int ile = ilosci.getOrDefault(emp.getJobTitle(), 0);
			ilosci.put(emp.getJobTitle(), ile + 1);
		}
		
		for(String job : sumy.keySet()) {
			int ile = ilosci.get(job);
			int suma = sumy.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("%-32s | %2d | %8.2f\n", job, ile, srednia);
		}
	}

}
